unit Unit1; 

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, LconvEncoding, LCLProc;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Edit1: TEdit;
    Label1: TLabel;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
  end; 

var
  Form1: TForm1; 

implementation

{ TForm1 }

procedure TForm1.FormShow(Sender: TObject);
var
  tfile: TStringList;
  str: string;
begin
  tfile:= TStringList.Create;
  tfile.LoadFromFile('File in Russian.txt');
  str:= tfile.Text;
  {$IFDEF WINDOWS}
    str:= SysToUTF8(str); // преобразование в кодировку UTF-8
  {$ENDIF}
  Memo1.Lines.Add(str);
  tfile.Free;
  Edit1.SetFocus;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  k: integer;
  text_UTF8, str_UTF8: string;
begin
  Edit1.SetFocus;
  if Edit1.Text= '' then
  begin
    ShowMessage('Введите строку для поиска');
    exit;
  end;
  text_UTF8:= UTF8Decode(Memo1.Text);
  str_UTF8:= UTF8Decode(Edit1.Text);
  k:= UTF8Pos(str_UTF8, text_UTF8);
  if k > 0 then
  begin
    Memo1.SetFocus;
    Memo1.SelStart:= k - 1;
    Memo1.SelLength:= UTF8Length(str_UTF8);
  end
  else
    ShowMessage('Строка не найдена');
end;

initialization
  {$I unit1.lrs}

end.

